//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"
#pragma package(smart_init)
#pragma resource "*.dfm"

#define MSG_LOUPE "Click anywhere on image to see LOUPE effect"
#define FX_LOUPE 0
#define MSG_TWIRL "Click anywhere on image to see TWIRL effect"
#define FX_TWIRL 1
#define MSG_ZOOM "Left click to zoom in, right click to zoom out"
#define FX_ZOOM 2
#define MSG_MAGICWAND "Click anywhere inside area you want to select"
#define FX_MAGICWAND 3

TForm1 *Form1;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  PixTwix = new TPixTwix(this);
  PixTwix->Unlock (WideString("your registration code here"));
  this->Caption = "PixTwix " + String(PixTwix->GetVersion()) + " demo project";
  path = ExtractFilePath(ParamStr(0));
  btnUndo->Enabled = false;
  Display->Picture ->LoadFromFile (path + "kids.jpg");
  undo_file = path + "undo.bmp";
  effect = -1;
  magnification = 1;
  zoomed_left = 0;
  zoomed_top = 0;
  TStringList *tmp = new TStringList();
  try
    {
    tmp->LoadFromFile (path + "demo.txt");
    ShowMessage(tmp->Text);
    }
  __finally
    {
    delete tmp;
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  delete PixTwix;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnUndoClick(TObject *Sender)
{
  if (PixTwix->UndoLoad(WideString(undo_file)))
    {
    UpdateDisplay();
    btnUndo->Enabled = false;
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Prepare()
{
  Graphics::TBitmap *tmp = new Graphics::TBitmap();
  try
    {
    tmp->Width = Display->Picture->Width ;
    tmp->Height = Display->Picture->Height ;
    tmp->Canvas->Draw (0, 0, Display->Picture->Graphic);
    PixTwix->SetPictureHandle (long(tmp->Handle));
    if (PixTwix->UndoSave(WideString(undo_file))) btnUndo->Enabled = true;
    else btnUndo->Enabled = false;
    }
  __finally
    {
    delete tmp ;
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UpdateDisplay()
{
  Display->Picture->Bitmap->Handle = (void*)PixTwix->GetPictureHandle() ;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Brightness1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Brightness (20, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Contrast1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Contrast(30, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnReloadClick(TObject *Sender)
{
  Display->Picture->LoadFromFile (path + "kids.jpg");
  effect = -1;
  magnification = 1;
  zoomed_left = 0;
  zoomed_top = 0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DisplayMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{

  int cx, cy;

  switch (effect)
    {

    case FX_LOUPE:
      Prepare();
      if (PixTwix->Loupe(X, Y, 120, 60)) UpdateDisplay();
      break;

    case FX_TWIRL:
      Prepare();
      if (PixTwix->Twirl(X, Y, 120)) UpdateDisplay();
      break;

    case FX_ZOOM:
      cx = zoomed_left + X / magnification;
      cy = zoomed_top + Y / magnification;
      if (Button == mbLeft) magnification = magnification * 2;
      else if (Button == mbRight) magnification = magnification / 2;
      if (magnification < 1) magnification = 1;
      if (PixTwix->Zoom(cx, cy, magnification))
        Display->Picture->Bitmap->Handle = (void*)PixTwix->GetSecondaryPictureHandle() ;
      zoomed_left = PixTwix->GetZoomedLeft();
      zoomed_top = PixTwix->GetZoomedTop();
      break;

    case FX_MAGICWAND:
      PixTwix->SelectNone();
      PixTwix->SelectUsingGlobalMagicWand (X, Y, 15, mwRGB);
      if (PixTwix->MaskNotSelected(0, 0, 0)) UpdateDisplay();
      break;

    }






}
//---------------------------------------------------------------------------

void __fastcall TForm1::Saturation1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Saturation(20, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Erodeborder1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->ErodeBorder(20, 255, 255, 255)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Drawframe1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Frame(16, 50, 50, 250, 220, 220, 220)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Paintoncanvas1Click(TObject *Sender)
{
  Prepare();
  int w = PixTwix->GetPictureWidth();
  int h = PixTwix->GetPictureHeight();
  if (PixTwix->PaintOnCanvas(w + 50, h + 50, 25, 25, 255, 255, 255, 10, 10, 6, 128, 128, 128)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Blackandwhite1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->BlackAndWhite(127, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Blackandwhitedithered1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->BlackAndWhiteDithered(0, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Colorize1Click(TObject *Sender)
{
  if (! dlgColor->Execute()) return;
  int R = PixTwix->GetRed(dlgColor->Color);
  int G = PixTwix->GetGreen(dlgColor->Color);
  int B = PixTwix->GetBlue(dlgColor->Color);
  Prepare();
  if (PixTwix->Colorize(R, G, B, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Grayscale1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Grayscale(gsWeighted, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Posterize1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Posterize(3, 3, 3, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Tint1Click(TObject *Sender)
{
  if (! dlgColor->Execute()) return;
  int R = PixTwix->GetRed(dlgColor->Color);
  int G = PixTwix->GetGreen(dlgColor->Color);
  int B = PixTwix->GetBlue(dlgColor->Color);
  Prepare();
  if (PixTwix->Tint(R, G, B, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Flip1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Flip()) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Reverse1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Reverse()) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Reflectleft1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Reflect(rmLeft)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Reflectright1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Reflect(rmRight)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Reflecttop1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Reflect(rmTop)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Reflectbottom1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Reflect(rmBottom)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Rotate90degrees1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Rotate90()) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Rotate180degrees1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Rotate180()) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Rotate270degrees1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Rotate270()) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Rotatewithclipping1Click(TObject *Sender)
{
  Prepare();
  int cx = PixTwix->GetPictureWidth() / 2;
  int cy = PixTwix->GetPictureHeight() / 2;
  if (PixTwix->RotatePicture(cx, cy, 45, 255, 255, 255)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Rotatewithoutclipping1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->RotatePictureEx(45, 255, 255, 255)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Encrypt1Click(TObject *Sender)
{
  Prepare();
  String password = InputBox("Image encryption", "Password", "");
  if (PixTwix->Encrypt(WideString(password))) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Decrypt1Click(TObject *Sender)
{
  Prepare();
  String password = InputBox("Image decryption", "Password", "");
  if (PixTwix->Decrypt(WideString(password))) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Cropandresize1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->CropPicture(0, 0, 400, 300))
    if (PixTwix->ResizePicture(640, 480, true)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Antialias1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Antialias(false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Blur1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->BlurMore(false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Soften1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->SoftenMore(false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Enhanceedge1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->EnhanceEdge(false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Sharpen1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Sharpen(false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Addnoise1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->AddNoise(50, true, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Blend1Click(TObject *Sender)
{
  Graphics::TBitmap *bmp;
  TPicture *pic;
  Prepare();
  pic = new TPicture() ;
  pic->LoadFromFile (path + "sunset.jpg");
  bmp = new Graphics::TBitmap() ;
  try
    {
    bmp->Width = pic->Width ;
    bmp->Height = pic->Height ;
    bmp->Canvas->Draw (0, 0, pic->Graphic);
    PixTwix->SetSecondaryPictureHandle (long(bmp->Handle));
    }
  __finally
    {
    delete pic ;
    delete bmp ;
    }
  if (PixTwix->Blend(50, 50, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Emboss1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Emboss(edNorthEast, 3, 127, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Loupe1Click(TObject *Sender)
{
  ShowMessage(MSG_LOUPE);
  effect = FX_LOUPE;        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Mosaic1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Mosaic(10, 10, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Scramble1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Scramble(100, 75)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Solarize1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Solarize(80, 80, 80, true, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Spray1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->Spray(20, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Texture1Click(TObject *Sender)
{
  Prepare();
  Graphics::TBitmap* bmp;
  TPicture *pic;
  pic = new TPicture() ;
  pic->LoadFromFile (path + "texture.jpg");
  bmp = new Graphics::TBitmap() ;
  try
    {
    bmp->Width = pic->Width ;
    bmp->Height = pic->Height ;
    bmp->Canvas->Draw (0, 0, pic->Graphic);
    PixTwix->SetSecondaryPictureHandle (long(bmp->Handle));
    }
  __finally
    {
    delete pic ;
    delete bmp ;
    }
  if (PixTwix->Texture(0, tmStretched, false)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Tile1Click(TObject *Sender)
{
  Prepare();
  if (PixTwix->TileEx(100, 75)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Twirl1Click(TObject *Sender)
{
  ShowMessage(MSG_TWIRL);
  effect = FX_TWIRL;        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Staggerrows1Click(TObject *Sender)
{
  Prepare();
  for (int i = 1; i < 6; i++) PixTwix->StaggerRows (true);
  UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Staggercolumns1Click(TObject *Sender)
{
  Prepare();
  for (int i = 1; i < 6; i++) PixTwix->StaggerColumns (true);
  UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Selectirregularregionandinvertselected1Click(
      TObject *Sender)
{
  Display->Picture->LoadFromFile (path + "kids.jpg");
  Prepare();
  PixTwix->SelectNone();
  PixTwix->SelectEllipse (10, 10, 250, 200);
  PixTwix->SelectEllipse (400, 70, 635, 500);
  if (PixTwix->Negative(true, true, true, true)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Selectirregularregionandapplytexturetoselection1Click(
      TObject *Sender)
{
  Graphics::TBitmap *bmp;
  TPicture *pic;
  Display->Picture->LoadFromFile (path + "kids.jpg");
  Prepare();
  PixTwix->SelectNone();
  PixTwix->SelectEllipse (10, 10, 250, 200);
  PixTwix->SelectEllipse (400, 70, 635, 500);
  pic = new TPicture() ;
  pic->LoadFromFile (path + "texture.jpg");
  bmp = new Graphics::TBitmap() ;
  try
    {
    bmp->Width = pic->Width ;
    bmp->Height = pic->Height ;
    bmp->Canvas->Draw (0, 0, pic->Graphic);
    PixTwix->SetSecondaryPictureHandle (long(bmp->Handle));
    }
  __finally
    {
    delete pic ;
    delete bmp ;
    }
  if (PixTwix->Texture(0, tmStretched, true)) UpdateDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Selectusingglobalmagicwandandmasknotselected1Click(
      TObject *Sender)
{
  Display->Picture->LoadFromFile (path + "kids.jpg");
  Prepare();
  ShowMessage(MSG_MAGICWAND);
  effect = FX_MAGICWAND;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Freezoom1Click(TObject *Sender)
{
  Prepare();
  ShowMessage(MSG_ZOOM);
  effect = FX_ZOOM;
}
//---------------------------------------------------------------------------

